var inquisitorParse = function ( source, callback )
{
    var result =
    {
        regions: {},
        rawevents: [],
        rawdialogue: [],
        rawlocations: []
    };

    var at = 0, ch, escapee =
    {
        '"': '"',
        '\\': '\\',
        '/': '/',
        b: '\b',
        f: '\f',
        n: '\n',
        r: '\r',
        t: '\t'
    }, text;

    var finished = false;

    var error = function ( m )
    {
        throw {
            name: 'SyntaxError',
            message: m,
            at: at,
            text: text
        };
    };

    var previous = function ()
    {
        at -= 1;
        ch = text.charAt( at );
        return ch;
    };

    var next = function ( c )
    {
        if ( c && c !== ch )
        {
            error( "Expected '" + c + "' instead of '" + ch + "'" );
        }

        ch = text.charAt( at );

        at += 1;
        return ch;
    };

    var previous = function ()
    {
        at -= 1;
        ch = text.charAt( at );
        return ch;
    };

    var white = function ()
    {
        while ( ch && ch <= ' ' )
        {
            next();
        }
    };

    var value;  // Place holder for the value function.

    var regions = [];

    var processconditional = function ( conditionone, conditiontwo, conditionthree, conditionfour )
    {
        if ( conditiontwo === undefined || conditiontwo === null )
        {
            conditiontwo = conditionone;
        }
        if ( conditionthree === undefined || conditionthree === null )
        {
            conditionthree = conditionone;
        }
        if ( conditionfour === undefined || conditionfour === null )
        {
            conditionfour = conditionone;
        }

        var processingindex = 0;
        var processresult = '';

        while ( ch !== conditionone && ch !== conditiontwo && ch !== conditionthree && ch !== conditionfour )
        {
            if ( processingindex > 0 )
            {
                processresult += ch;
            }
            next();
            processingindex++;
        }

        return processresult;
    }

    var location = function ()
    {
        if ( ch === '~' || ch === '^' )
        {
            var key,
                location = {};
            location.name = "";
            location.fullname = "";
            location.descriptionsegments = [];
            location.namesegments = [];
            location.eventid = -1;
            location.dialogueid = -1;
            location.linkoverrides = {};
            location.linkadditions = {};
            location.id = result.rawlocations.length;
            location.isobject = ( ch === '^' );
            location.displayparent = location.isobject;
            location.descriptioninparent = "";
            location.hidden = false;

            console.log( "inquisitorParse: Processing " + ( location.isobject ? "Object" : "Location" ) );

            next();
            if ( ch === "^" )
            {
                location.displayparent = true;
                next();
            }

            if( result.rawdialogue.length > 0 )
            {
                if ( result.rawdialogue[result.rawdialogue.length - 1].locationid == location.id )
                {
                    location.dialogueid = result.rawdialogue[result.rawdialogue.length - 1].id;
                    console.log( "inquisitorParse: Attached Dialogue: " + location.dialogueid );
                }
            }

            if ( result.rawevents.length > 0 )
            {
                if ( result.rawevents[result.rawevents.length - 1].locationid == location.id )
                {
                    location.eventid = result.rawevents[result.rawevents.length - 1].id;
                    console.log( "inquisitorParse: Attached Event: " + location.eventid );
                }
            }

            var namesegmentid = 0;
            var namesegmentcurrent = "";
            var namesegmentcurrentposition = 0;
            while ( at < text.length )
            {
                if ( namesegmentid == 0 || namesegmentcurrentposition > 1 )
                {
                    namesegmentcurrent += ch;
                }
                location.fullname += ch;
                next();

                namesegmentcurrentposition++;
                if ( ch === '-' || ch === '\n' )
                {
                    namesegmentid++;
                    location.namesegments.push( namesegmentcurrent.trim() );
                    namesegmentcurrent = "";
                    namesegmentcurrentposition = 0;
                }

                if ( ch === '\n' )
                {
                    break;
                }
            }
            console.log( "inquisitorParse: Creating location: " + location.fullname + " with ID: " + location.id );
            console.log( "inquisitorParse: Found " + namesegmentid + " name segments." );

            location.region = location.namesegments[0];
            location.subregion = location.namesegments[1];
            location.name = location.namesegments[namesegmentid - 1];

            console.log( "inquisitorParse: Found location region: " + location.region );
            console.log( "inquisitorParse: Found location name: " + location.name );

            //

            var descindex = 0;
            var currentdescriptionsegment = "";

            while ( ch !== '~' && at < text.length && ch !== '#' && ch !== '^' && ch !== '/' )
            {
                if ( ch === '[' )
                {
                    var overrideprocessingindex = 0;
                    var override = { title: '', target: '', conditional: '', hasconditional: false, exclusionconditional: false, token: '', action: '', displayaschild: false }

                    next();
                    if ( ch === "^" )
                    {
                        override.displayaschild = true;
                        next();
                    }
                    previous();

                    override.target += processconditional( ':' );
                    override.title += processconditional( ']', '?', '!', '+' );

                    //

                    if ( ch === '?' )
                    {
                        next();
                        override.combinationcondition = ( ch === '*' );

                        if ( !override.combinationcondition )
                        {
                            previous();
                        }

                        override.conditional += processconditional( ']', '+' );
                        override.hasconditional = true;
                        override.conditional = override.conditional.trim();
                        console.log( "inquisitorParse: Found Conditional: " + override.conditional );
                    }

                    if ( ch === '!' )
                    {
                        override.conditional += processconditional( ']', '+' );
                        override.hasconditional = true;
                        override.exclusionconditional = true;
                        override.conditional = override.conditional.trim();
                        console.log( "inquisitorParse: Found Exclusion Conditional: " + override.conditional );
                    }

                    //

                    if ( ch === '+' )
                    {
                        override.token += processconditional( ']', '-' );
                        override.token = override.token.trim();
                        console.log( "inquisitorParse: Found Token: " + override.token );
                    }

                    //

                    if ( ch === '-' )
                    {
                        override.action += processconditional( ']' );
                        override.action = override.action.trim();
                        console.log( "inquisitorParse: Found Action: " + override.action );
                    }

                    if ( override.title === '' )
                    {
                        override.title = override.target;
                    }

                    location.linkoverrides[override.target] = override;
                    console.log( "inquisitorParse: Found location override. Title: " + override.title + ". Target: " + override.target );
                    next();
                }
                else if ( ch === '{' )
                {
                    var additionprocessingindex = 0;
                    var targetaddition = { target: '', title: '', conditional: '', hasconditional: false, exclusionconditional: false, token: '', action: '', displayaschild: false }

                    next();
                    if ( ch === "^" )
                    {
                        targetaddition.displayaschild = true;
                        next();
                    }
                    previous();

                    targetaddition.target += processconditional( ':' );
                    targetaddition.title += processconditional( '}', '?', '+', '!' );

                    //

                    if ( ch === '?' )
                    {
                        next();
                        targetaddition.combinationcondition = (ch === '*');
                        previous();

                        targetaddition.conditional += processconditional( '}', '+' );
                        targetaddition.hasconditional = true;
                        targetaddition.conditional = targetaddition.conditional.trim();
                        console.log( "inquisitorParse: Found Conditional: " + targetaddition.conditional );
                    }

                    if ( ch === '!' )
                    {
                        targetaddition.conditional += processconditional( '}', '+' );
                        targetaddition.hasconditional = true;
                        targetaddition.exclusionconditional = true;
                        targetaddition.conditional = targetaddition.conditional.trim();
                        console.log( "inquisitorParse: Found Exclusion Conditional: " + targetaddition.conditional );
                    }

                    //

                    if ( ch === '+' )
                    {
                        targetaddition.token += processconditional( '}', '-' );
                        targetaddition.token = targetaddition.token.trim();
                        console.log( "inquisitorParse: Found Token: " + targetaddition.token );
                    }

                    //

                    if ( ch === '-' )
                    {
                        targetaddition.action += processconditional( '}' );
                        targetaddition.action = targetaddition.action.trim();
                        console.log( "inquisitorParse: Found Action: " + targetaddition.action );
                    }

                    //

                    location.linkadditions[targetaddition.target] = targetaddition;
                    console.log( "inquisitorParse: Found target addition. Title: " + targetaddition.title + ". Target: " + targetaddition.target );
                    next();
                }
                else if ( ch === '|' )
                {
                    var olddescriptionsegment = { text: currentdescriptionsegment, requiresactivation: false, postactivationtext: '' }
                    location.descriptionsegments.push( olddescriptionsegment ); currentdescriptionsegment = '';

                    console.log( "inquisitorParse: Found active note, processing." );

                    var newdescriptionsegment = { text: '', requiresactivation: true, active: false, postactivationtext: '', additional: false, givetoken: '', requiretoken: '', requireinversion: false }
                    newdescriptionsegment.text += processconditional( ':' );

                    console.log( "inquisitorParse: Found active note inactive text: " + newdescriptionsegment.text );

                    next();
                    newdescriptionsegment.additional = ( ch === '*' );

                    console.log( "inquisitorParse: Is additional note: " + newdescriptionsegment.additional );

                    newdescriptionsegment.postactivationtext += processconditional( '|', '+', '?', '!' );

                    if ( ch === '+' )
                    {
                        newdescriptionsegment.givetoken += processconditional( '|', '?', '!' );
                        newdescriptionsegment.givetoken = newdescriptionsegment.givetoken.trim();
                        console.log( "inquisitorParse: Found Token to Give: " + newdescriptionsegment.givetoken );
                    }

                    if ( ch === '?' || ch === '!' )
                    {
                        newdescriptionsegment.requireinversion = ( ch === '!' );
                        newdescriptionsegment.requiretoken += processconditional( '|', '+' );
                        newdescriptionsegment.requiretoken = newdescriptionsegment.requiretoken.trim();
                        console.log( "inquisitorParse: Found Token to Require: " + newdescriptionsegment.requiretoken );
                    }

                    console.log( "inquisitorParse: Found active note active text: " + newdescriptionsegment.postactivationtext );

                    location.descriptionsegments.push( newdescriptionsegment );
                    next();
                }
                else if ( ch === '@' )
                {
                    var titletext = processconditional( '\n' ).substring(1);
                    next();
                    currentdescriptionsegment += titletext;
                }
                else if ( ch === '&' && location.isobject )
                {
                    var descriptioninparent = processconditional( '\n' );
                    next();
                    location.descriptioninparent += '\n' + '\n' + descriptioninparent;
                }
                else
                {
                    //

                    if ( descindex > 0 )
                    {
                        currentdescriptionsegment += ch;
                    }
                    next();
                    descindex++;
                }
            }

            //

            var olddescriptionsegment = { text: currentdescriptionsegment.trimRight(), requiresactivation: false, active: true, postactivationtext: '' }
            location.descriptionsegments.push( olddescriptionsegment ); currentdescriptionsegment = '';
            console.log( "inquisitorParse: Found location description: " + location.descriptionsegments[0].text );

            //

            var regionceptiondepth = 0;
            var parentregionception;
            var regionception = result.regions;
            var lastid = -1;

            while ( regionceptiondepth < namesegmentid )
            {
                if ( !( regionception.hasOwnProperty( location.namesegments[regionceptiondepth] ) ) )
                {
                    regionception[location.namesegments[regionceptiondepth]] = {
                        id: location.id,
                        firstid: location.id,
                        isobject: location.isobject,
                        parentid: lastid
                    };
                    console.log( "inquisitorParse: Creating new Region: " + location.namesegments[regionceptiondepth] + ". Depth: "
                        + regionceptiondepth + ". Parent ID: " + regionception[location.namesegments[regionceptiondepth]].parentid );
                }
                else
                {
                    console.log( "inquisitorParse: Found parent Region: " + location.namesegments[regionceptiondepth] + ". Depth: " + regionceptiondepth + ". ID: " + lastid );

                    /*if ( regionceptiondepth == namesegmentid - 1 )
                    {
                        regionception[location.namesegments[regionceptiondepth]].id = location.id;
                    }*/
                }

                if ( !regionception[location.namesegments[regionceptiondepth]].isobject )
                {
                    lastid = regionception[location.namesegments[regionceptiondepth]].id;
                }

                parentregionception = regionception;
                regionception = regionception[location.namesegments[regionceptiondepth]];
                regionceptiondepth++;
            }

            location.parent = parentregionception;
            result.rawlocations.push( location );

            return location;
        }

        error( "Bad Location" );
    };

    var event = function ()
    {
        var key,
            event = {};
        event.text = "";
        event.id = result.rawevents.length;
        event.locationid = result.rawlocations.length;
        event.condition = '';
        event.givetoken = '';
        event.soundurl = '';

        console.log( "inquisitorParse: Processing Event: " + event.id + " in location: " + event.locationid );

        if ( ch === '#' )
        {
            next( '#' );

            if ( ch === '[' )
            {
                var condition = processconditional( ']', '+' ).trim();
                console.log( "inquisitorParse: Found Event Conditional: " + condition );

                if ( ch === '+' )
                {
                    event.givetoken += processconditional( ']' );
                    event.givetoken = event.givetoken.trim();
                    console.log( "inquisitorParse: Found Token: " + event.givetoken );
                }

                event.condition = condition;
                next();
            }

            while ( ch !== '#' && ch !== '[' )
            {
                if ( ch === '@' )
                {
                    var titletext = processconditional( '\n' );
                    next();
                    event.text += "<notetitle>" + titletext + "</notetitle>";
                }
                else if ( ch === '&' )
                {
                    var soundurl = processconditional( '\n' );
                    next();
                    event.soundurl += soundurl;
                    console.log( "inquisitorParse: Found event sound: " + event.soundurl );
                }
                else
                {
                    event.text += ch;
                    next();
                }
            }

            console.log( "inquisitorParse: Found event text: " + event.text );
            result.rawevents.push( event );

            next( '#' );

            return event;
        }

        error( "Bad Event" );
    };

    var dialogue = function ()
    {
        var dialogue = {};
        dialogue.rawtext = "";
        dialogue.id = result.rawdialogue.length;
        dialogue.locationid = result.rawlocations.length;
        dialogue.readprogress = 0;

        next();

        dialogue.rawtext += ch;
        dialogue.rawtext += processconditional( '/' );

        dialogue.text = dialogue.rawtext.split( '\n');

        console.log( "inquisitorParse: Found dialogue text: " + dialogue.rawtext );
        result.rawdialogue.push( dialogue );

        next();

        return dialogue;
    };

    var value = function ()
    {
        console.log( "inquisitorParse: Finding object to process" );

        switch ( ch )
        {
            case '/':
                return dialogue();
            case '~':
                return location();
            case '^':
                return location();
            case '#':
                return event();
            default:
                next();
                return '';
        }
    };

    console.log( "inquisitorParse: Began parser." );

    //

    var client = new XMLHttpRequest();
    client.open( 'GET', source );

    client.onreadystatechange = function ()
    {
        if ( this.readyState == this.DONE )
        {
            text = client.responseText;
            next();
            console.log( "inquisitorParse: Loaded source. Length: " + text.length + " characters." );

            //

            while ( at < text.length )
            {
                value();
            }

            callback( result );
        }
    }

    client.send();

}